/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.migration;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.config.migration.DataMigrator;
import com.google.gson.JsonElement;
import craftpresence.external.me.hypherionmc.moonconfig.core.AbstractConfig;
import craftpresence.external.me.hypherionmc.moonconfig.core.UnmodifiableConfig;
import craftpresence.external.me.hypherionmc.moonconfig.core.file.FileConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HypherConverter
implements DataMigrator {
    private static final Pattern EXPR_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final int LOWEST_SUPPORTED = 13;
    private static final int HIGHEST_SUPPORTED = 18;
    private final int fileVersion;
    private final String configPath;
    private final String serverEntriesPath;
    private final String replayModPath;
    private final Map<String, String> placeholderMappings = new HashMapBuilder().put((Object)"%player%", (Object)"{player.name}").put((Object)"%world%", (Object)"{dimension.name}").put((Object)"%mods%", (Object)"{general.mods}").put((Object)"%difficulty%", (Object)"{world.difficulty}").put((Object)"%position%", (Object)"{custom.player_info_coordinate}").put((Object)"%biome%", (Object)"{biome.name}").put((Object)"%mcver%", (Object)"{general.version}").put((Object)"%instance%", (Object)"{pack.name}").put((Object)"%launcher%", (Object)"{general.brand}").put((Object)"%server%", (Object)"{replace(server.address.short, '.', '_')}").put((Object)"%launchername%", (Object)"{toLower(general.brand)}").put((Object)"%savename%", (Object)"{world.name}").put((Object)"%playerhead%", (Object)"{player.icon}").put((Object)"%gametime12%", (Object)"{world.time.format_12}").put((Object)"%gametime%", (Object)"{world.time.format_24}").put((Object)"%day%", (Object)"{world.day}").put((Object)"%weather%", (Object)"{world.weather.name}").put((Object)"%replayframe%", (Object)"{replaymod.frames.current}").put((Object)"%replaytotal%", (Object)"{replaymod.frames.total}").put((Object)"%replaytime%", (Object)"{replaymod.time.current}").put((Object)"%replaytimeleft%", (Object)"{replaymod.time.remaining}").put((Object)"%serverip%", (Object)"{server.address.short}").put((Object)"%servername%", (Object)"{server.name}").put((Object)"%players%", (Object)"{server.players.current}").put((Object)"%playersexcl%", (Object)"{server.players.current - 1}").put((Object)"%maxplayers%", (Object)"{server.players.max}").put((Object)"%motd%", (Object)"{server.motd.raw}").put((Object)"%servericon%", (Object)"{server.icon}").put((Object)"%realmname%", (Object)"{server.name}").put((Object)"%realmdescription%", (Object)"{server.motd.raw}").put((Object)"%realmgame%", (Object)"{server.minigame}").put((Object)"%realmicon%", (Object)"{server.icon}").build();
    private int configVersion = -1;
    private int serverEntryVersion = -1;
    private int replayModVersion = -1;

    public HypherConverter(Map.Entry<Integer, String> entry) {
        this.fileVersion = entry.getKey();
        this.configPath = entry.getValue() + "simple-rpc.toml";
        this.serverEntriesPath = entry.getValue() + "server-entries.toml";
        this.replayModPath = entry.getValue() + "simple-rpc-replaymod.toml";
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        File replayModFile;
        Constants.LOG.info("Simple RPC (By: HypherionSA) config data found, attempting to migrate settings to CraftPresence...", new Object[0]);
        try (FileConfig conf = FileConfig.of(this.configPath);){
            String name;
            AbstractConfig entry;
            Object object;
            boolean launcherIntegration;
            conf.load();
            this.configVersion = conf.getOrElse("general.version", Integer.valueOf(-1));
            Constants.LOG.debugInfo("Main Config file found (Version: %d, File Version: %d), interpreting data...", new Object[]{this.configVersion, this.fileVersion});
            if (!MathUtils.isWithinValue((double)this.configVersion, (double)13.0, (double)18.0, (boolean)true, (boolean)true)) {
                Constants.LOG.error("You are using an unsupported Simple RPC config file (Supported Versions: v%d - v%d, Found Version: v%d), skipping...", new Object[]{13, 18, this.configVersion});
                Config config = instance;
                return config;
            }
            Object clientId = this.getProperty(conf, "general.applicationID", "general.clientID");
            if (clientId != null) {
                instance.generalSettings.clientId = clientId.toString();
            }
            instance.advancedSettings.debugMode = (Boolean)conf.get("general.debugging");
            instance.generalSettings.detectATLauncherInstance = launcherIntegration = ((Boolean)conf.get("general.launcherIntegration")).booleanValue();
            instance.generalSettings.detectCurseManifest = launcherIntegration;
            instance.generalSettings.detectMCUpdaterInstance = launcherIntegration;
            instance.generalSettings.detectTechnicPack = launcherIntegration;
            instance.generalSettings.detectMultiMCManifest = launcherIntegration;
            boolean areOverridesEnabled = (Boolean)conf.get("dimension_overrides.enabled");
            Object dimensionList = conf.get("dimension_overrides.dimensions");
            if (dimensionList instanceof List) {
                List dimensions = (List)dimensionList;
                object = dimensions.iterator();
                while (object.hasNext()) {
                    Object entryObj = object.next();
                    if (!(entryObj instanceof AbstractConfig)) continue;
                    entry = (AbstractConfig)entryObj;
                    name = entry.get("name").toString();
                    boolean isBiome = name.startsWith("biome:");
                    if (isBiome) {
                        name = name.replaceFirst("biome:", "");
                    }
                    ModuleData data = new ModuleData().setData(this.convertPresenceData(entry, areOverridesEnabled, true));
                    (isBiome ? instance.biomeSettings.biomeData : instance.dimensionSettings.dimensionData).put(name, data);
                }
            }
            if ((object = conf.get("custom.variables")) instanceof List) {
                List customVars = (List)object;
                for (Object entryObj : customVars) {
                    if (!(entryObj instanceof AbstractConfig)) continue;
                    entry = (AbstractConfig)entryObj;
                    name = entry.get("name").toString();
                    String value = entry.get("value").toString();
                    instance.displaySettings.dynamicVariables.put(name, this.processPlaceholder(value));
                }
            }
            instance.advancedSettings.enablePerGui = true;
            instance.advancedSettings.guiSettings.guiData.put("RealmsScreen", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("realms_list"))));
            instance.advancedSettings.guiSettings.guiData.put("JoinMultiplayerScreen", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("server_list"))));
            instance.advancedSettings.guiSettings.guiData.put("LevelLoadingScreen", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("join_game"))));
            instance.advancedSettings.guiSettings.guiData.put("ReceivingLevelScreen", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("join_game"))));
            instance.statusMessages.loadingData.setData(this.convertPresenceData((AbstractConfig)conf.get("init")));
            instance.statusMessages.mainMenuData.setData(this.convertPresenceData((AbstractConfig)conf.get("main_menu")));
            instance.statusMessages.realmData.setData(this.convertPresenceData((AbstractConfig)conf.get("realms")));
            instance.statusMessages.singleplayerData.setData(this.convertPresenceData((AbstractConfig)conf.get("single_player")));
            instance.serverSettings.serverData.get("default").setData(this.convertPresenceData((AbstractConfig)conf.get("multi_player")));
            instance.displaySettings.presenceData = this.convertPresenceData((AbstractConfig)conf.get("generic"));
            instance.save();
        }
        File serverEntriesFile = new File(this.serverEntriesPath);
        if (serverEntriesFile.exists()) {
            try (FileConfig conf = FileConfig.of(serverEntriesFile);){
                conf.load();
                this.serverEntryVersion = (Integer)conf.get("version");
                Constants.LOG.debugInfo("Server Entries file found (Version: %d, File Version: %d), interpreting data...", new Object[]{this.serverEntryVersion, this.fileVersion});
                boolean areOverridesEnabled = (Boolean)conf.get("enabled");
                Object t = conf.get("entry");
                if (t instanceof List) {
                    List entries = (List)t;
                    for (Object entryObj : entries) {
                        if (!(entryObj instanceof AbstractConfig)) continue;
                        AbstractConfig entry = (AbstractConfig)entryObj;
                        instance.serverSettings.serverData.put((String)entry.get("ip"), new ModuleData().setData(this.convertPresenceData(entry, areOverridesEnabled, true)));
                    }
                }
                instance.save();
            }
        }
        if ((replayModFile = new File(this.replayModPath)).exists()) {
            try (FileConfig conf = FileConfig.of(replayModFile);){
                conf.load();
                this.replayModVersion = (Integer)conf.get("general.version");
                Constants.LOG.debugInfo("Replay Mod Integration file found (Version: %d, File Version: %d), interpreting data...", new Object[]{this.replayModVersion, this.fileVersion});
                instance.advancedSettings.enablePerGui = true;
                instance.advancedSettings.guiSettings.guiData.put("GuiReplayViewer", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("replay_viewer"))));
                instance.advancedSettings.guiSettings.guiData.put("GuiReplayOverlay", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("replay_editor"))));
                instance.advancedSettings.guiSettings.guiData.put("GuiVideoRenderer", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("replay_render"))));
                instance.save();
            }
        }
        Constants.LOG.info("Migration complete, thanks for using our mods! ~~ CDAGaming and HypherionSA", new Object[0]);
        return instance;
    }

    private String processPlaceholder(String original, boolean addMetadata) {
        Object result = original;
        if (addMetadata) {
            result = "'" + original + "'";
        }
        if (!StringUtils.isNullOrEmpty((String)result)) {
            for (Map.Entry<String, String> entry : this.placeholderMappings.entrySet()) {
                result = ((String)result).replace(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private String processPlaceholder(String original) {
        return this.processPlaceholder(original, false);
    }

    private PresenceData convertPresenceData(AbstractConfig entry, boolean isEnabled, boolean useAsMain) {
        PresenceData data = new PresenceData();
        data.enabled = isEnabled;
        data.useAsMain = useAsMain;
        data.details = this.processPlaceholder((String)entry.get("description"));
        data.gameState = this.processPlaceholder((String)entry.get("state"));
        if (this.isActive(ConfigFlag.USE_IMAGE_POOLS)) {
            data.largeImageKey = this.combineData((List)entry.get("largeImageKey"));
            data.smallImageKey = this.combineData((List)entry.get("smallImageKey"));
        } else {
            data.largeImageKey = this.processPlaceholder((String)entry.get("largeImageKey"));
            data.smallImageKey = this.processPlaceholder((String)entry.get("smallImageKey"));
        }
        data.largeImageText = this.processPlaceholder((String)entry.get("largeImageText"));
        data.smallImageText = this.processPlaceholder((String)entry.get("smallImageText"));
        data.startTimestamp = "{data.general.time}";
        int buttonIndex = 1;
        Object t = entry.get("buttons");
        if (t instanceof List) {
            List buttons = (List)t;
            for (Object buttonEntryObj : buttons) {
                if (!(buttonEntryObj instanceof AbstractConfig)) continue;
                AbstractConfig buttonEntry = (AbstractConfig)buttonEntryObj;
                Button buttonData = new Button(this.processPlaceholder((String)buttonEntry.get("label")), this.processPlaceholder((String)buttonEntry.get("url")));
                data.addButton("button_" + buttonIndex, buttonData);
                ++buttonIndex;
            }
        }
        return data;
    }

    private String combineData(List<String> items) {
        StringBuilder dataBuilder = new StringBuilder();
        if (!items.isEmpty()) {
            if (items.size() > 1) {
                dataBuilder.append("{randomString(");
                for (int i = 0; i < items.size(); ++i) {
                    String output = this.processPlaceholder(items.get(i), true);
                    boolean hasExpr = EXPR_PATTERN.matcher(output).find();
                    dataBuilder.append(hasExpr ? "getResult(" : "").append(output).append(hasExpr ? ")" : "");
                    if (i >= items.size() - 1) continue;
                    dataBuilder.append(",");
                }
                dataBuilder.append(")}");
            } else {
                dataBuilder.append(this.processPlaceholder(items.getFirst()));
            }
        }
        return dataBuilder.toString();
    }

    private PresenceData convertPresenceData(AbstractConfig entry, boolean useAsMain) {
        return this.convertPresenceData(entry, entry.getOrElse("enabled", Boolean.valueOf(true)), useAsMain);
    }

    private PresenceData convertPresenceData(AbstractConfig entry) {
        return this.convertPresenceData(entry, true);
    }

    private boolean isActive(ConfigFlag flag) {
        return !(this.configVersion >= 0 && this.configVersion < flag.configVersion || this.serverEntryVersion >= 0 && this.serverEntryVersion < flag.serverEntryVersion || this.replayModVersion >= 0 && this.replayModVersion < flag.replayModVersion);
    }

    private Object getProperty(UnmodifiableConfig instance, String ... terms) {
        for (String term : terms) {
            if (!instance.contains(term)) continue;
            return instance.get(term);
        }
        return null;
    }

    private static enum ConfigFlag {
        USE_IMAGE_POOLS(17, 2, 1);

        private final int configVersion;
        private final int serverEntryVersion;
        private final int replayModVersion;

        private ConfigFlag(int configVersion, int serverEntryVersion, int replayModVersion) {
            this.configVersion = configVersion;
            this.serverEntryVersion = serverEntryVersion;
            this.replayModVersion = replayModVersion;
        }

        public String toString() {
            return "ConfigFlag[key=" + StringUtils.getOrDefault((String)this.name(), (String)"N/A") + "; configVersion=" + this.configVersion + "; serverEntryVersion=" + this.serverEntryVersion + "; replayModVersion=" + this.replayModVersion + "]";
        }
    }
}

